import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Setup figure and axis
fig, ax = plt.subplots(figsize=(10, 8))

# Grid dimensions
rows, cols = 5, 4
tile_size = 1

# Define colors
clear_color = 'lightgreen'
occupied_color = 'lightcoral'
robot_colors = {'robot1': 'white', 'robot2': 'black'}

# Draw tiles and robots
for row in range(rows):
    for col in range(cols):
        tile_id = f"tile_{row}-{col+1}"
        x, y = col * tile_size, (rows - row - 1) * tile_size
        
        # Determine tile status
        if (row, col) == (1, 0):
            tile_color = occupied_color
            robot = 'robot1'
        elif (row, col) == (1, 1):
            tile_color = occupied_color
            robot = 'robot2'
        else:
            tile_color = clear_color
            robot = None
        
        # Draw tile
        ax.add_patch(patches.Rectangle((x, y), tile_size, tile_size, facecolor=tile_color, edgecolor='black'))
        ax.text(x + tile_size / 2, y + tile_size / 2, tile_id, color='black', ha='center', va='center', fontsize=8, fontweight='bold')
        
        # Draw robot if present
        if robot:
            ax.add_patch(patches.Circle((x + tile_size / 2, y + tile_size / 2), 0.3, facecolor=robot_colors[robot], edgecolor='black'))
            ax.text(x + tile_size / 2, y + tile_size / 2 - 0.4, robot, color='black', ha='center', va='center', fontsize=8, fontweight='bold')

# Create legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=occupied_color, edgecolor='black', label='Occupied Tile'),
    patches.Patch(facecolor='white', edgecolor='black', label='Robot holding White'),
    patches.Patch(facecolor='black', edgecolor='black', label='Robot holding Black')
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.1, 1))

# Set limits and aspect
ax.set_xlim(0, cols)
ax.set_ylim(0, rows)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('tiles/one_shot/ini_diagram_code/attempts/attempt_48.png', bbox_inches='tight')
plt.show()